@echo off
:: Silent install batch script. All configuration settings belong in opos6XXX.ini 

:: old install already present?
@echo Searching for previous 'OPOS for the Ingenico 6XXX' installations...
call cscript //B IsOPOSPresent.vbs
if exist hasOPOS.tmp goto UNINSTALL
@echo No previous installations found.
GOTO PRECONFIG

:UNINSTALL
@echo Previous version found. Uninstalling...
call "silent uninstall"
@del hasOPOS.tmp
GOTO PRECONFIG

:PRECONFIG
:: Determine which components to install
call "silent install options"
@echo off

:: Now that options are specified, we can determine the download info location
echo [Download] >tmp.ini
echo DownloadInfoFile=%TARGET%\download.ini >>tmp.ini

:: also set up IBM EFT Executable Location
echo IBM EFT Executable=%TARGET%\ibmeftdl.exe >>tmp.ini

:: and CHFormNumber
echo CHFormNumber=255 >>tmp.ini

:: create temporary install settings
copy /y "Silent Install Settings.iss" tmp.iss

:: number of components
SET COUNT=0

:: assume no form entries needed
SET PUSH_FORM_ENTRIES=NO

:CONFIG
if %INGENICO_CTRLS%==YES goto ADD_1
if %OPOS_CONTROLS%==YES goto ADD_2
if %CTRL_PANEL_APP%==YES goto ADD_3
if %OPOS_SERVICES%==YES goto ADD_4
echo szDir=%TARGET% >>tmp.iss
echo Component-count=%COUNT% >>tmp.iss
echo Result=1 >>tmp.iss
echo [{464EDCE1-E217-47A2-9851-F1C7CF27F8D9}-SdAskDestPath2-0] >>tmp.iss
echo szDir=%TARGET% >>tmp.iss
echo Result=1 >>tmp.iss
GOTO INSTALL
 
:ADD_1
echo Component-%COUNT%=Ingenico-specific Controls >>tmp.iss
SET /A COUNT=%COUNT%+1
SET INGENICO_CTRLS=""
SET PUSH_FORM_ENTRIES=YES
GOTO CONFIG

:ADD_2
echo Component-%COUNT%=OPOS Control Objects >>tmp.iss
SET /A COUNT=%COUNT%+1
SET OPOS_CONTROLS=""
GOTO CONFIG

:ADD_3
echo Component-%COUNT%=Control Panel Application >>tmp.iss
SET /A COUNT=%COUNT%+1
SET CTRL_PANEL_APP=""
GOTO CONFIG

:ADD_4
echo Component-%COUNT%=OPOS Service Objects for the Ingenico 6XXX >>tmp.iss
SET /A COUNT=%COUNT%+1
SET OPOS_SERVICES=""
GOTO CONFIG

:INSTALL
@echo Performing silent installation of OPOS for the Ingenico 6XXX
@"OPOS for the Ingenico i6XXX" /s /f1"%CD%\tmp.iss" 
@echo Installshield portion complete. Updating system registry with opos6XXX.ini
@regpusher opos6XXX.ini Connection SOFTWARE\OLEforRetail\ServiceOPOS\SignatureCapture\Ing6XXX
@regpusher opos6XXX.ini LineDisplay SOFTWARE\OLEforRetail\ServiceOPOS\LineDisplay\Ing6XXX REG_SZ
@regpusher opos6XXX.ini MSR SOFTWARE\OLEforRetail\ServiceOPOS\MSR\Ing6XXX
@regpusher opos6XXX.ini PINPad SOFTWARE\OLEforRetail\ServiceOPOS\PINPad\Ing6XXX
@regpusher opos6XXX.ini POSKeyboard SOFTWARE\OLEforRetail\ServiceOPOS\POSKeyboard\Ing6XXX
@regpusher opos6XXX.ini SignatureCapture SOFTWARE\OLEforRetail\ServiceOPOS\SignatureCapture\Ing6XXX
@regpusher tmp.ini Download SOFTWARE\OLEforRetail\ServiceOPOS\SignatureCapture\Ing6XXX
if %PUSH_FORM_ENTRIES%==YES goto FORMPUSH
GOTO CLEANUP

:FORMPUSH
@regpusher opos6XXX.ini IVICMForm SOFTWARE\OLEforRetail\ServiceOPOS\IVICMForm\Ing6XXX
GOTO CLEANUP

:CLEANUP
del tmp.iss
del tmp.ini
SET TARGET=
SET COUNT=
SET PUSH_FORM_ENTRIES=

@echo on
@echo Silent installation complete.

